#!/bin/sh

CLST_PAGE_VERIFY_SHUTDOWN_RESULT_MSG=""
CLST_PAGE_VERIFY_SHUTDOWN_RESULT_OK=0
CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ERROR=1

CLST_PAGE_VERIFY_SHUTDOWN_RESULT_CODE=${CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ERROR}
CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ROLLING=0


clst_page_verify_shutdown() {
    debug_print "clst_page_verify_shutdown"
    
    tp_yesno \
        "${CLST_PAGE_VERIFY_SHUTDOWN_TITLE}" \
        "${CLST_PAGE_VERIFY_SHUTDOWN_TEXT}" \
        "${CLST_PAGE_VERIFY_SHUTDOWN_LABEL_OK}" \
        "${CLST_PAGE_VERIFY_SHUTDOWN_LABEL_CANCEL}"

    if [ "${TP_YESNO_RESULT_CODE}" == "${TP_YESNO_RESULT_ERROR}" ]; then
        CLST_PAGE_VERIFY_SHUTDOWN_RESULT_CODE=$CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ERROR
        CLST_PAGE_VERIFY_SHUTDOWN_RESULT_MSG=""
        CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ROLLING=0
        return
    fi
        
    case "${TP_YESNO_RESULT_SELECT}" in
        "${TP_YESNO_RESULT_YES}")
        
            debug_print "ShutdownComputer..."
            #shutdown -P now
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_CODE=$CLST_PAGE_VERIFY_SHUTDOWN_RESULT_OK
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_MSG=""
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ROLLING=1
            return
            ;;
            
        "${TP_YESNO_RESULT_NO}")
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_CODE=$CLST_PAGE_VERIFY_SHUTDOWN_RESULT_OK
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_MSG=""
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ROLLING=-1
            return
            ;;
            
        *)
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_CODE=$CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ERROR
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_MSG="${CLST_PAGE_VERIFY_SHUTDOWN_ERROR_UNKNOWN}"
            CLST_PAGE_VERIFY_SHUTDOWN_RESULT_ROLLING=0
            return
            ;;
    esac
}